<h1 align="center">
  <img src="./README_assets/img/mascot.jpg" alt="Karing" width="256" />
  <br>
  Karing - Simple & Powerful proxy utility
  <br>
</h1>

<h3 align="center">
A <a href="https://github.com/SagerNet/sing-box">singbox</a> GUI based on <a href="https://github.com/flutter/flutter">flutter</a>.
</h3>


English | [Chinese](./README_cn.md) | [Russian](./README_ru.md) | [Persian](./README_fa.md)
### Note: Karing has not opened any channel related to Karing on any video platform

## Features
- Compatible with Clash, V2ray/V2fly, Sing-box, Shadowsocks, Sub, Github Subscriptions.
  - Full `clash` config supported, Partial `clash.meta` config supported.

- A set of routing rules applied to multiple subscription sources automatically selects efficient nodes.
- Supports custom routing rule groups and node groups.
  - Customizes default routing rule groups for novice users - ready to use right out of the box.
  - Built-in geo-IP, geo-site, ACL, and [other rulesets](https://github.com/KaringX/karing-ruleset/)

- Backup and synchronization, synchronizing multiple devices with a single configuration.
  - Supports iCloud synchronization [IOS/MacOS].
  - Supports synchronization within the local area network.
  - Supports WebDAV.
  - Supports importing/exporting ZIP files.

- Built-in support for [the modified sing-box core](https://github.com/KaringX/sing-box).
- Introduces a beginner mode for simpler configuration.
- Plan to support more platforms.


## Promotion
<details>
<summary>View all promotions


### 推荐机场

[狗狗加速 —— 技术流机场 Doggygo VPN](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)

- 高性能海外机场，海外团队，无跑路风险
- 专属链接注册送 3 天，每天 1G 流量 [免费试用](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)
- 优惠套餐每月仅需 15.8 元，160G 流量，年付 8 折
- 全球首家支持`Hysteria2` 协议，集群负载均衡设计，高速专线，极低延迟，无视晚高峰，4K 秒开
- 解锁流媒体及 ChatGPT


[👉更多机场优惠 每日更新](https://1.x31415926.top/)


</summary>

### 🤝VPN Providers Collaboration Announcement
- 👉[Contact information and forms of cooperation](https://karing.app/blog/isp/cooperation#for-vpn-providers-from-other-regions)👈
</details>

## System Requirements
- Windows >= 10 (64-bit only)
- Android >= 8 (arm64-v8a, armeabi-v7a)
- Linux (64-bit only)
- IOS >= 15
- MacOS >= 12 (Intel, Apple Silicon)
- TvOS >= 17

## Install
- **IOS/TvOS AppStore**: (Search Keywords: karing vpn)
  - https://apps.apple.com/us/app/karing/id6472431552
- **IOS/TvOS TestFlight**:
  - https://testflight.apple.com/join/RLU59OsJ
- **Android**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
  - APKPure https://apkpure.com/p/com.nebula.karing
  - Amazon AppStore https://www.amazon.com/gp/product/B0DJSQDDM8
- **Windows/Macos/Linux**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
 


### FAQ

> [FAQ|en](https://karing.app/en/faq/)


## Todos
- Platform to be supported:
  - linux | [linglong](https://linglong.dev/)
- Globalization(multi-language)
  - If you are willing to work with us to support Karing globalization, please contact us [Telegram](https://t.me/ovowe)


## Screenshots (Windows version)

<div align="center">
  <img src="./README_assets/demo/home.png" alt="demo1" width="50%" />
  </br></br>
  <img src="./README_assets/demo/select_server.png" alt="demo2" width="50%" />
    </br></br>
  <img src="./README_assets/demo/connections.png" alt="demo3" width="50%" />
  </br></br>
  <img src="./README_assets/demo/setting.png" alt="demo4" width="50%" />
  </br></br>
  <img src="./README_assets/demo/routing_group.png" alt="demo5" width="50%" />
  </br></br>
  <img src="./README_assets/demo/add_profile_link.png" alt="demo6" width="50%" />
</div>


## Contributions
[welcome to report issue!](https://github.com/KaringX/karing/issues)


## Donate
![donate](./README_assets/img/donate-usdt.jpg)


## Projects 
### Acknowledgement: Karing was based on or inspired by these projects and so on:

- [flutter](https://flutter.dev/): makes it easy and fast to build beautiful apps for mobile and beyond.
- [singbox](https://sing-box.sagernet.org/): The universal proxy platform.
- [Meta-Docs](https://wiki.metacubex.one/config/): Clash.Meta docs

### Karing Team:
- [Karing](https://karing.app): https://karing.app
- [Clash Mi](https://clashmi.app/): https://clashmi.app/
- [sing-poet](https://github.com/KaringX/sing-poet)



## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=KaringX/karing&type=Date)](https://star-history.com/#KaringX/karing&Date)

